import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
  
/** An instance is a JFrame that displays a Clock
    and a one-line JLabel underneath it */
public class GUI extends JFrame {
   private Clock clock;
   private JLabel label;
   
   /** Constructor: an instance with clock c and label s */
   public GUI(Clock c, String s) {
      setBackground(new Color(255, 235, 222));
      setTitle("The clockgame");
      label= new JLabel(s);
      clock= c;
      
      // Place the clock and label on the JFrame and
      // show the JFrame
         Container cp= getContentPane();
         cp.add(clock, "North");
         cp.add(label, "South");
         pack();
         setLocation(0,40);
         setVisible(true); 
   }
      
   /** Set the label to s */
   public void setLabel(String s) {
      label.setText(s);
      repaint();
   }
}
